import java.io.*;

public class Main {
  public double pobierzLiczbe(StreamTokenizer strTok)
  throws IOException {
    while(strTok.nextToken() != StreamTokenizer.TT_NUMBER){
      System.out.println("To nie jest poprawna liczba.");
      System.out.print("Wprowadź poprawną liczbę: ");
    }
    return strTok.nval;
  }

  public void oblicz(double A, double B, double C) {
    System.out.println ("Parametry równania:\n");
    System.out.println ("A: " + A + " B: " + B + " C: " + C + "\n");

    if (A == 0){
      System.out.println ("To nie jest równanie kwadratowe: A = 0!");
    }
    else{
      double delta = B * B - 4 * A * C;

      if (delta < 0){
        System.out.println ("Delta < 0");
        System.out.println ("To równanie nie ma rozwiązania w " + 
                            "zbiorze liczb rzeczywistych.");
      }
      else if(delta == 0){
        double wynik = -B / (2 * A);
        System.out.println ("Rozwiązanie: x = " + wynik);
      }
      else if(delta > 0){
        double wynik;
        wynik = (-B + Math.sqrt(delta)) / (2 * A);
        System.out.print ("Rozwiązanie: x1 = " + wynik);
        wynik = (-B - Math.sqrt(delta)) / (2 * A);
        System.out.println (", x2 = " + wynik);
      }
    }
  }
  public void start() {
    StreamTokenizer strTok = new StreamTokenizer(
      new BufferedReader(
        new InputStreamReader(System.in)
      )
    );

    double paramA = 0;
    double paramB = 0;
    double paramC = 0;

    try{
      System.out.print("Podaj parametr A: ");
      paramA = pobierzLiczbe(strTok);
      System.out.print("Podaj parametr B: ");
      paramB = pobierzLiczbe(strTok);
      System.out.print("Podaj parametr C: ");
      paramC = pobierzLiczbe(strTok);
      System.out.println("");
    }
    catch(IOException e){
      System.out.println("Błąd podczas odczytu strumienia.");
      return;
    }
    oblicz(paramA, paramB, paramC);
  }
  public static void main (String args[]) {
    Main main = new Main();
    main.start();
  }
}
